<?php

namespace Juweliere\JuwApiClient\Entity;


class User extends AbstractEntity
{
    /** @var string */
    protected $id;

    /** @var string */
    protected $userId;

    /** @var string */
    protected $gender;

    /** @var string */
    protected $firstName;

    /** @var string */
    protected $lastName;

    /** @var string */
    protected $email;

    /** @var string */
    protected $phone;

    /** @var \DateTime */
    protected $birthdate;

    /** @var boolean */
    protected $contactPhone = true;

    /** @var boolean */
    protected $contactEmail = true;

    /** @var Address[] */
    protected $addresses;

    /** @var User\WishlistItem[] */
    protected $wishlistItems;

    /** @var Order\Order[] */
    protected $orders;

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setUserId($id): self
    {
        $this->userId = $id;

        return $this;
    }

    public function setId($id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender($gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName($firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName($lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone($phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getBirthdate(): ?\DateTime
    {
        return $this->birthdate;
    }

    public function setBirthdate(\DateTime $birthdate = null): self
    {
        $this->birthdate = $birthdate;

        return $this;
    }

    public function getContactPhone(): ?bool
    {
        return $this->contactPhone;
    }

    public function setContactPhone(bool $contactPhone): self
    {
        $this->contactPhone = $contactPhone;

        return $this;
    }

    public function getContactEmail(): ?bool
    {
        return $this->contactEmail;
    }

    public function setContactEmail(bool $contactEmail): self
    {
        $this->contactEmail = $contactEmail;

        return $this;
    }

    /**
     * @return Address[]
     */
    public function getAddresses(): ?array
    {
        return $this->addresses;
    }

    /**
     * @return Address[]
     */
    public function setAddresses(?array $addresses = null): self
    {
        $this->addresses = $addresses;

        return $this;
    }

    /**
     * @return User\WishlistItem[]
     */
    public function getWishlistItems(): ?array
    {
        return $this->wishlistItems;
    }

    /**
     * @return User\WishlistItem[]
     */
    public function setWishlistItems(?array $wishlistItems = null): self
    {
        $this->wishlistItems = $wishlistItems;

        return $this;
    }


    /**
     * @return Order\Order[]
     */
    public function getOrders(): ?array
    {
        return $this->orders;
    }

    /**
     * @return Order\Order[]
     */
    public function setOrders(?array $orders = null): self
    {
        $this->orders = $orders;

        return $this;
    }
}
