<?php


namespace Juweliere\JuwApiClient\Service;

use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\User;
use Juweliere\JuwApiClient\Entity\User\Login;
use Juweliere\JuwApiClient\Entity\User\Password;
use Juweliere\JuwApiClient\Entity\User\Recovery;
use Juweliere\JuwApiClient\Entity\User\RecoveryToken;

class WishlistItems
{
    use ServiceTrait;

    protected $baseUrlResource = "/me/wishlistitems";

    /**
     * @param WishlistItem $wishlistItem
     * @return WishlistItem
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function addItemToWishlist(User\WishlistItem $wishlistItem)
    {

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($wishlistItem)
            ]
        );

        $wishlistResponse = new User\WishlistItem();

        return $this->getResponse($request, $wishlistResponse);
    }

    /**
     * @return WishlistItem
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function deleteItemFromWishlist($id)
    {

        $request =  $this->provider->getAuthenticatedRequest(
            "DELETE",
            $this->baseUrl . "/" . $id,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ]
            ]
        );

        $result =  $this->provider->getHttpClient()->send($request);

        return true;
    }
}
