<?php


namespace Juweliere\JuwApiClient;

use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\MessageFormatter;
use GuzzleHttp\Middleware;
use Monolog\Formatter\LineFormatter;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Logger;
use Psr\Log\LoggerInterface;

class HttpClientProvider
{
    private LoggerInterface $logger;

    /**
     * @var Client
     */
    private $client;

    /**
     * HttpClientProvider constructor.
     * @param $logPath
     */
    public function __construct(LoggerInterface $logger)
    {

        $this->logger = $logger;
        $stack = $this->getStack();

        $parameters = [
            'timeout' => 5,
            'handler' => $stack,
        ];

        $this->client = new Client($parameters);
    }

    /**
     * @return Client
     */
    public function get() {
        return $this->client;
    }

    /**
     * @return HandlerStack
     */
    private function getStack() {

        /** @var HandlerStack $stack */
        $stack = HandlerStack::create();

        /** @var string $logFormat */
        $logFormat = Constants::GUZZLE_LOG_FORMAT_DEBUG;

        $stack->push(
            Middleware::log(
                $this->logger,
                new MessageFormatter($logFormat)
            )
        );

        return $stack;
    }
}