<?php


namespace Juweliere\JuwApiClient\Entity;


abstract class AbstractEntity implements \JsonSerializable
{

    public function jsonSerialize()
    {
        $data = get_object_vars($this);

        return $this->cleanArray($data);
    }

    private function cleanArray($data)
    {
        foreach ($data as $k => $v) {
            if (is_array($v)) {
                $data[$k] = $this->cleanArray($v);
            }

            if ($data[$k] === null || (is_array($data[$k]) && count(($data[$k])) === 0)) {
                unset($data[$k]);
            }
        }

        return $data;
    }
}