<?php

namespace Juweliere\JuwApiClient\Entity\Order;


use Cassandra\Date;
use Juweliere\JuwApiClient\Entity\AbstractEntity;
use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\User;

class Order extends AbstractEntity
{
    /** @var string */
    protected $id;

    /** @var string|null */
    protected $status;

    /** @var string|null */
    protected $source;

    /** @var Payment|null */
    protected $payment;

    /** @var string|null */
    protected $log;

    /** @var Payment|null */
    protected $lastPayment;

    /** @var boolean */
    protected $pickupInStore = false;

    /** @var int|null */
    protected $pickupStoreId;

    /** @var int|null */
    protected $number;

    /** @var string|null */
    protected $trackingUrl;

    /** @var string|null */
    protected $comment;

    /** @var string|null */
    protected $message;

    /** @var boolean|null */
    protected $giftPack = false;

    /** @var boolean|null */
    protected $sendNotification;

    /** @var Address|null */
    protected $billingAddress;

    /** @var Address|null */
    protected $shippingAddress;

    /** @var array|Item[]  */
    protected array $items;

    /** @var \DateTime */
    protected $createdAt;

    /** @var User */
    protected $user;

    /** @var array|Log[]  */
    protected array $logs;


    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId($id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getSource(): ?string
    {
        return $this->source;
    }

    public function setSource(?string $source): self
    {
        $this->source = $source;

        return $this;
    }

    public function setPickupInStore(?bool $pickupInStore): self
    {
        $this->pickupInStore = $pickupInStore;

        return $this;
    }

    public function getPickupInStore(): ?string
    {
        return $this->pickupInStore;
    }

    /**
     * @param int|null $pickupInStoreId
     * @return Order
     */
    public function setPickupStoreId(?int $pickupStoreId): Order
    {
        $this->pickupStoreId = $pickupStoreId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPickupStoreId(): ?int
    {
        return $this->pickupStoreId;
    }

    /**
     * @return array|Item[]
     */
    public function getItems(): array
    {
        return $this->items;
    }

    public function addItem(Item $item): bool
    {
        if (!empty($this->items)) {
            foreach ($this->items as $key => $existingItem) {
                if ($existingItem->getSku() === $item->getSku()) {
                    $this->items[$key] = $item;
                    return true;
                }
            }
        }

        $this->items[] = $item;

        return true;
    }

    public function removeItem($sku): bool
    {
        if (!empty($this->items)) {
            foreach ($this->items as $key => $existingItem) {
                if ($existingItem->getSku() === $sku) {
                    array_splice($this->items, $key, 1);
                    return true;
                }
            }
        }

        return true;
    }

    /**
     * @return array|Log[]
     */
    public function getLogs(): array
    {
        return $this->logs;
    }

    public function setLogs(array $logs): void
    {
        $this->logs = $logs;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Payment
     */
    public function getOrderPayments(): Payment
    {
        return $this->payment;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser($user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getBillingAddress(): ?Address
    {
        return $this->billingAddress;
    }

    public function setBillingAddress($billingAddress): self
    {
        $this->billingAddress = $billingAddress;

        return $this;
    }

    public function getShippingAddress(): ?Address
    {
        return $this->shippingAddress;
    }

    public function setShippingAddress($shippingAddress): self
    {
        $this->shippingAddress = $shippingAddress;

        return $this;
    }

    /**
     * @return Payment|null
     */
    public function getPayment(): ?Payment
    {
        return $this->payment;
    }

    /**
     * @param Payment|null $payment
     */
    public function setPayment(?Payment $payment): void
    {
        $this->payment = $payment;
    }

    /**
     * @return Payment|null
     */
    public function getLastPayment(): ?Payment
    {
        return $this->lastPayment;
    }

    /**
     * @param Payment|null $lastPayment
     */
    public function setLastPayment(?Payment $lastPayment): void
    {
        $this->lastPayment = $lastPayment;
    }

    /**
     * @param string $uuid
     */
    public function setUuid(string $uuid): void
    {
        $this->uuid = $uuid;
    }

    /**
     * @param array|Item[] $items
     */
    public function setItems(array $items): void
    {
        $this->items = $items;
    }

    /**
     * @return float|int|null
     */
    public function getAmount() {
        $amount = 0;
        /** @var Item $item */
        foreach ($this->items as $item) {
            $amount += $item->getPrice();
        }

        return $amount;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt(): \DateTime
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     */
    public function setCreatedAt(\DateTime $createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @param int|null $number
     * @return Order
     */
    public function setNumber(?int $number): Order
    {
        $this->number = $number;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getNumber(): ?int
    {
        return $this->number;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     */
    public function setComment(?string $comment): void
    {
        $this->comment = $comment;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param string|null $message
     */
    public function setMessage(?string $message): void
    {
        $this->message = $message;
    }

    public function setGiftPack(?bool $giftPack): self
    {
        $this->giftPack = $giftPack;

        return $this;
    }

    public function getGiftPack(): ?bool
    {
        return $this->giftPack;
    }

    /**
     * @return string|null
     */
    public function getTrackingUrl(): ?string
    {
        return $this->trackingUrl;
    }

    /**
     * @param string|null $trackingUrl
     */
    public function setTrackingUrl(?string $trackingUrl): void
    {
        $this->trackingUrl = $trackingUrl;
    }

    /**
     * @return bool|null
     */
    public function getSendNotification(): ?bool
    {
        return $this->sendNotification;
    }

    /**
     * @param bool $sendNotification
     */
    public function setSendNotification(bool $sendNotification): void
    {
        $this->sendNotification = $sendNotification;
    }

    /**
     * @return string|null
     */
    public function getLog(): ?string
    {
        return $this->log;
    }

    /**
     * @param string $log
     */
    public function setLog($log): void
    {
        $this->log = $log;
    }
}
