<?php


namespace Juweliere\JuwApiClient\Service;

use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\User;
use Juweliere\JuwApiClient\Entity\User\Login;
use Juweliere\JuwApiClient\Entity\User\Password;
use Juweliere\JuwApiClient\Entity\User\Recovery;
use Juweliere\JuwApiClient\Entity\User\RecoveryToken;

class Addresses
{
    use ServiceTrait;

    protected $baseUrlResource = "/me/addresses";

    /**
     * @param Address $address
     * @return Address
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function add(Address $address)
    {

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($address)
            ]
        );

        $addressResponse = new Address();

        return $this->getResponse($request, $addressResponse);
    }

    /**
     * @return Bool
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function delete($id)
    {

        $request =  $this->provider->getAuthenticatedRequest(
            "DELETE",
            $this->baseUrl . "/" . $id,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ]
            ]
        );

        $result =  $this->provider->getHttpClient()->send($request);

        return true;
    }

    /**
     * @return WishlistItem
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function update(Address $address)
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "PATCH",
            $this->baseUrl . "/" . $address->getId(),
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/merge-patch+json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($address)
            ]
        );

        $addressResponse = new Address();

        return $this->getResponse($request, $addressResponse);
    }
}
