<?php

namespace Juweliere\JuwApiClient\Entity\User;

use Juweliere\JuwApiClient\Entity\AbstractEntity;

class Registration extends AbstractEntity
{
    /** @var string */
    protected $email;

    protected $emailRepeat;

    /** @var string */
    protected $firstName;

    /** @var string */
    protected $lastName;

    /** @var string */
    protected $password;

    /**
     * @return string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getEmailRepeat(): ?string
    {
        return $this->emailRepeat;
    }

    /**
     * @param string $emailRepeat
     */
    public function setEmailRepeat(string $emailRepeat): void
    {
        $this->emailRepeat = $emailRepeat;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName($firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName($lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return string
     */
    public function getPlainPassword(): string
    {
        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPlainPassword(string $password): void
    {
        $this->password = $password;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPassword(string $password): void
    {
        $this->password = $password;
    }
}
