<?php


namespace Juweliere\JuwApiClient\Service;

use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\Order\Dashboard;
use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\User;

class Orders
{
    use ServiceTrait;

    protected $baseUrlResource = "/me/orders";

    /**
     * @return Order[]
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getAll($page = 1)
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "?_page=" . $page,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Accept' => 'application/ld+json'
                ]
            ]
        );

        return $this->getResponse($request, new Order(), true);
    }

    /**
     * @return Order[]
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getDashboard()
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "/dashboard",
            $this->getAccessToken()
        );

        $dashboard = new Dashboard();

        return $this->getResponse($request, $dashboard);
    }

    /**
     * @return Order
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function get($uuid)
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "/" . $uuid,
            $this->getAccessToken()
        );

        $order = new Order();

        return $this->getResponse($request, $order);
    }
    /**
     * @return User
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getByUser($uuid)
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "/users/" . $uuid,
            $this->getAccessToken()
        );

        $user = new User();

        return $this->getResponse($request, $user);
    }

    /**
     * @return bool
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function delete(string $uuid) {

        $request =  $this->provider->getAuthenticatedRequest(
            "DELETE",
            $this->baseUrl . "/users/" . $uuid . "/delete",
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Accept' => 'application/json'
                ]
            ]
        );

        $this->provider->getHttpClient()->send($request);

        return true;
    }

    public function confirmPaypal($uuid, $payerId) {

        $confirm = array("payerId" => $payerId);

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl . "/" . $uuid . "/confirm",
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($confirm)
            ]
        );

        $confirmResponse = new Order();

        return $this->getResponse($request, $confirmResponse);

    }

    /**
     * @param Order $order
     * @return Order
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function create(Order $order) {

        if ($order->getUser()->getId() !== null) {
            $order->getUser()->setUserId($order->getUser()->getId());
            $order->getUser()->setId(null);
        }


        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($order)
            ]
        );

        $orderResponse = new Order();

        return $this->getResponse($request, $orderResponse);
    }


    /**
     * @return Order
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function update(Order $order)
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "PATCH",
            $this->baseUrl . "/" . $order->getId(),
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/merge-patch+json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($order)
            ]
        );

        $addressResponse = new Order();

        return $this->getResponse($request, $addressResponse);
    }
}
