<?php

namespace Juweliere\JuwApiClient\Entity\Order;


use Juweliere\JuwApiClient\Entity\AbstractEntity;

class Payment extends AbstractEntity
{
    /** @var int */
    protected $id;

    /** @var string */
    protected $type;

    /** @var string */
    protected $externalId;

    /** @var string|null */
    protected $captureId;

    /** @var float */
    protected $amount;

    /** @var string */
    protected $data;

    /** @var string|null */
    protected $clientSecret;

    /** @var string|null */
    protected $redirect;

    /** @var string|null */
    protected $sessionData;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getExternalId(): ?string
    {
        return $this->externalId;
    }

    public function setExternalId(?string $externalId): self
    {
        $this->externalId = $externalId;

        return $this;
    }

    public function getCaptureId(): ?string
    {
        return $this->captureId;
    }

    public function setCaptureId(?string $captureId): self
    {
        $this->captureId = $captureId;

        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getData(): ?string
    {
        return $this->data;
    }

    public function setData(?string $data): self
    {
        $this->data = $data;

        return $this;
    }

    /**
     * @return string
     */
    public function getClientSecret()
    {
        return $this->clientSecret;
    }

    /**
     * @param string $clientSecret
     */
    public function setClientSecret($clientSecret): void
    {
        $this->clientSecret = $clientSecret;
    }

    /**
     * @return string
     */
    public function getRedirect()
    {
        return $this->redirect;
    }

    /**
     * @param string $redirect
     */
    public function setRedirect($redirect): void
    {
        $this->redirect = $redirect;
    }

    /**
     * @return string
     */
    public function getSessionData()
    {
        return $this->sessionData;
    }

    /**
     * @param string $sessionData
     */
    public function setSessionData(?string $sessionData): self
    {
        $this->sessionData = $sessionData;

        return $this;
    }
}
