<?php

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('juweliere_product');

        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('base_url')
                    ->children()
                        ->scalarNode('decorator')->end()
                    ->end()
                ->end() // base_url
                ->arrayNode('authorization')
                    ->children()
                        ->scalarNode('token')->end()
                    ->end()
                ->end() // base_url
            ->end()
        ;

        return $treeBuilder;
    }
}