<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\ElasticSearch;

use Symfony\Component\HttpClient\ScopingHttpClient;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

abstract class AbstractElasticParser
{
    protected $httpClient;

    public function __construct(HttpClientInterface $httpClient, $baseUrl, $accessToken)
    {
        $client = $httpClient;
        $this->httpClient = new ScopingHttpClient($client, [
            'base_uri' => $baseUrl,
            'http_version' => '1.1',
            'auth_bearer' => $accessToken
        ]);
    }

    /**
     * @param string $uuid
     *
     * @return array|null
     *
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function get(string $uri): ?array
    {
        $response = $this->httpClient->request('GET', $uri, [
            'base_uri' => 'https://vogl.online-dekorateur.de',
            'http_version' => '1.1',
        ]);

        if (200 === $response->getStatusCode()) {
            return $response->toArray();
        }

        return null;
    }
}
