<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\ElasticSearch;

use Symfony\Component\HttpClient\ScopingHttpClient;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

abstract class AbstractElasticParser
{
    protected $httpClient;
    private $baseUrl;
    private $accessToken;

    /**
     * AbstractElasticParser constructor.
     * @param HttpClientInterface $httpClient
     * @param $baseUrl
     * @param $accessToken
     */
    public function __construct(HttpClientInterface $httpClient, $baseUrl, $accessToken)
    {
        $this->baseUrl = $baseUrl;
        $this->accessToken = $accessToken;

        $this->httpClient = new ScopingHttpClient($httpClient, [
            'base_uri' => $this->baseUrl,
            'http_version' => '1.1',
            'auth_bearer' => $this->accessToken
        ]);
    }

    /**
     * @param string $uuid
     *
     * @return array|null
     *
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function get(string $uri, $auth = true): ?array
    {
        $response = $this->httpClient->request('GET', $uri, [
            'base_uri' => $this->baseUrl,
            'http_version' => '1.1'
        ]);

        if (200 === $response->getStatusCode()) {
            return $response->toArray();
        }

        return null;
    }
}
