<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\ElasticSearch;

use Symfony\Component\HttpClient\ScopingHttpClient;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class ElasticParser extends AbstractElasticParser
{
    /**
     * @param string $uuid
     *
     * @return array|null
     *
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function getSingleWidget(string $uuid): ?array
    {
        $uri = sprintf('/api/elastic/widgets/%s', $uuid);
        return $this->get($uri);
    }

    /**
     * @param string $uuid
     *
     * @return array|null
     *
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function getCustomproductlis(string $uuid): ?array
    {
        $uri = sprintf('/api/elastic/customproductlists/%s', $uuid);
        return $this->get($uri);
    }
}
