<?php

namespace Juweliere\ProductBundle\Session;


class CatalogFilterManager extends SessionManager
{
    const ON_STOCK_FILTER = "stock";

    public function addFilter($uuid, $filter)
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {

            $key = $filter['code'];
            $value = $filter['value'];
            if (isset($entry['filters']) && isset($entry['filters'][$key]) && !is_array($entry['filters'][$key])) {
                unset($entry['filters'][$key]);
            }

            if (!isset($entry['filters'][$key]) ||
                (isset($entry['filters'][$key]) && !in_array($value, $entry['filters'][$key]))) {
                $entry['filters'][$key][] = $value;
            }

            $this->session->set($uuid, $entry);
        } else {
            $key = $filter['code'];
            $value = $filter['value'];

            $entry['filters'][$key][] = $value;

            $this->session->set($uuid, $entry);
        }
    }

    public function removeFilter($uuid, $filter)
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            if (isset($entry['filters'])) {
                if (key_exists($filter, $entry['filters'])) {
                    unset($entry['filters'][$filter]);
                }

                $this->session->set($uuid, $entry);
            }
        }
    }

    public function removeOption($uuid, $filter, $option)
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            if (isset($entry['filters'])) {
                if (key_exists($filter, $entry['filters'])) {
                    $key = array_search($option, $entry['filters'][$filter]);
                    if ($key !== false) {
                        unset($entry['filters'][$filter][$key]);
                    }
                    if (empty($entry['filters'][$filter])) {
                        unset($entry['filters'][$filter]);
                    }
                }

                $this->session->set($uuid, $entry);
            }
        }
    }

    public function removeEntry($uuid)
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            foreach ($entry['filters'] as $key => $filter) {
                unset($entry['filters'][$key]);
            }

            $this->session->set($uuid, $entry);

            return true;
        }

        return false;
    }

    /**
     * @param $uuid
     * @param bool $value
     */
    public function setStockFilter($uuid, $value = true)
    {
        $entry = $this->getEntry($uuid);

        if (!$entry) {
           $entry [self::ON_STOCK_FILTER] = $value;
        } else {
            $entry = array(
                self::ON_STOCK_FILTER => $value
            );
        }

        $this->session->set($uuid, $entry);

        return true;
    }
}
