<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;

use Carbon\Carbon;
use Exception;

class ProductDataHelper
{
    /**
     * @param array $product
     * @return array
     */
    public function consolidateGalleryImages(array $product)
    {
        /*echo "<pre>";
        var_dump($product["gallery"]);
        var_dump($product["image"]);*/

        if (!empty($product["gallery"])) {
            /** @var array $images */
            $images = array();

            if (isset($product["image"])) {
                $images[] = array(
                    "path" => $product["image"]
                );
            }

            usort($product["gallery"], function ($item1, $item2) {
                return $item1['position'] <=> $item2['position'];
            });

            foreach ($product["gallery"] as $image) {
                /** @var string $imagePath */
                $imagePath = explode('_', $product["image"], 2);

                /** @var string $galleryPath */
                $galleryPath = explode('_', $image["path"], 2);

                if (!isset($imagePath[1]) || !isset($galleryPath[1]) || $imagePath[1] != $galleryPath[1]) {
                    $images[] = $image;
                }

            }

            $product["gallery"] = $images;
        }

        /* var_dump($product["gallery"]);
         echo "</pre>";
         die();*/

        return $product;
    }

    /**
     * @param array $product
     *
     * @return array|null
     *
     * @throws Exception
     */
    public function getPrice(?array $product): ?array
    {
	if (!$product) {
	   return null;
	}

        $showPrice = (bool) $product['showPrice'];
        if (!$showPrice) {
            return null;
        }

        $rrp = isset($product['rrp']) ? (float) $product['rrp'] : null;

        $data = [
            'rrp' => [
                'value' => $rrp,
                'currency' => '€',
            ],
            'specialPrice' => null,
            'actualPrice' => [
                'value' => $rrp,
                'currency' => '€',
            ],
        ];

        $specialsPrices = isset($product['prices']) && sizeof($product['prices']) > 0 ? $product['prices'] : null;

        if ($specialsPrices) {
            foreach ($specialsPrices as $specialsPrice) {
                $validFrom = new Carbon($specialsPrice['validFrom']);
                $validThrough = new Carbon($specialsPrice['validThrough']);

                $now = Carbon::now();

                if ($validFrom->lte($now) && $validThrough->gte($now)) {
                    if ($specialsPrice['currency'] === $data['actualPrice']['currency']) {
                        $data['specialPrice'] = [
                            'value' => (float) $specialsPrice['price'],
                            'currency' => $specialsPrice['currency'],
                        ];

                        $data['actualPrice']['value'] = (float) $specialsPrice['price'];
                    }
                }
            }
        }

        return $data;
    }
}
