<?php

namespace Juweliere\ProductBundle\Session;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

class SessionManager
{
    protected $session;

    public function __construct(SessionInterface $session)
    {
        $this->session = $session;
    }

    public function setPage(string $uuid, int $page)
    {
        $entry = $this->getEntry($uuid);

        $entry['page'] = $page;
        $this->session->set($uuid, $entry);
    }

    public function setLimit(string $uuid, int $limit)
    {
        $entry = $this->getEntry($uuid);

        $entry['limit'] = $limit;
        $this->session->set($uuid, $entry);
    }

    public function setSorting(string $uuid, string $sorter, string $dir = 'asc')
    {
        $entry = $this->getEntry($uuid);

        $entry['sort'] = $sorter;
        $entry['dir'] = $dir;
        $this->session->set($uuid, $entry);
    }

    public function getEntry($uuid)
    {
        if ($this->session->has($uuid)) {
            return $this->session->get($uuid, []);
        }
    }
}
