<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Decorator;

use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\ProductBundle\Decorator\AbstractDecoratorApiClient;

class DecoratorApi extends AbstractDecoratorApiClient
{
    public function createBasket($sku, $qty = 1) {
        return $this->post("/api/products/" . $sku . "/baskets", array("qty" => $qty));
    }

    public function removeBasket($sku, $qty = 1) {
        return $this->post("/api/products/" . $sku . "/baskets/remove", array("qty" => $qty));
    }

    public function createCheckout(Order $order) {
        return $this->post("/api/checkouts", $order);
    }
}
