<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;


use Symfony\Component\HttpFoundation\Request;

class TemplateProvider implements TemplateProviderInterface
{
    private $deviceDetection = false;

    public function __construct($deviceDetection = false)
    {
        $this->deviceDetection = $deviceDetection;
    }

    public function getRelatedProducts(Request $request, $small = false): string
    {
        $template = 'pages/product/_related';

        if ($this->deviceDetection) {
            $device = $request->get('device');

            switch ($device) {
                case 'tablet':
                    $template = 'pages/product/tablet/_related';
                    break;
                case 'mobile':
                    $template = 'pages/product/mobile/_related';
                    break;
                default:
                    $template = 'pages/product/desktop/_related';
                    break;
            }
        }

        if ($small) {
            $template .= "_small";
        }

        $template .= ".html.twig";

        return $template;
    }

    public function getProductPage(Request $request): string
    {
        $template = 'pages/product.html.twig';

        if ($this->deviceDetection) {
            $device = $request->get('device');

            switch ($device) {
                case 'mobile':
                    $template = 'pages/product/mobile/_product.html.twig';
                    break;
                case 'tablet':
                    $template = 'pages/product/tablet/_product.html.twig';
                    break;
                default:
                    $template = 'pages/product/desktop/_product.html.twig';
                    break;
            }
        }

        return $template;
    }
}
