<?php

namespace Juweliere\ProductBundle\Session;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

class SessionManager
{
    const SESSION_LAST_SEEN = "lastseen";

    protected $session;

    public function __construct(SessionInterface $session)
    {
        $this->session = $session;
    }

    public function setPage(string $uuid, int $page)
    {
        $entry = $this->getEntry($uuid);

        $entry['page'] = $page;
        $this->session->set($uuid, $entry);
    }

    public function setLimit(string $uuid, int $limit)
    {
        $entry = $this->getEntry($uuid);

        $entry['limit'] = $limit;
        $this->session->set($uuid, $entry);
    }

    public function setSorting(string $uuid, string $sorter, string $dir = 'asc')
    {
        $entry = $this->getEntry($uuid);

        $entry['sort'] = $sorter;
        $entry['dir'] = $dir;
        $this->session->set($uuid, $entry);
    }

    public function getEntry($uuid)
    {
        if ($this->session->has($uuid)) {
            return $this->session->get($uuid, []);
        }
    }

    /**
     * @param $product
     * @param SessionInterface $session
     * @return array|mixed
     */
    public function getLastSeenProducts($product)
    {
        /** @var array $lastSeenProducts */
        $lastSeenProducts = array();

        /** @var array $newLastSeenProducts */
        $newLastSeenProducts = array();

        /** @var int $count */
        $count = 0;

        /** @var array $attributes */
        $attributes = array(
            "sku",
            "image",
            "brand",
            "name",
            "showPrice",
            "rrp"
        );

        if ($this->session->has(self::SESSION_LAST_SEEN)) {
            $lastSeenProducts = $this->session->get(self::SESSION_LAST_SEEN);
        }

        if (is_null($product)) {
            return $lastSeenProducts;
        }

        foreach ($lastSeenProducts as $key => $lastSeenProduct) {
            if ($count > 4) {
                break;
            }
            if ($lastSeenProduct["sku"] === $product["sku"]) {
                continue;
            }
            $newLastSeenProducts[] = $lastSeenProduct;
            $count++;
        }

        /** @var array $productDataFiltered */
        $productDataFiltered = array_intersect_key($product, array_flip($attributes));

        array_unshift($newLastSeenProducts, $productDataFiltered);

        $this->session->set(self::SESSION_LAST_SEEN, $newLastSeenProducts);
        $this->session->save();

        array_shift($newLastSeenProducts);

        return $newLastSeenProducts;
    }
}
