<?php

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('juweliere_product');

        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('redirect')
                    ->children()
                        ->scalarNode('notavailable')->end()
                    ->end()
                ->end() // redirect
                ->arrayNode('base_url')
                    ->children()
                        ->scalarNode('decorator')->end()
                    ->end()
                ->end() // base_url
                ->arrayNode('authorization')
                    ->children()
                        ->scalarNode('token')->end()
                    ->end()
                ->end() // authorization
                ->arrayNode('template')
                    ->children()
                        ->scalarNode('device_detection')->end()
                        ->scalarNode('description_twocolumns')->end()
                    ->end()
                ->end()
                ->arrayNode('log')
                    ->children()
                        ->scalarNode('path')->end()
                        ->scalarNode('level')->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
