<?php

namespace Juweliere\ProductBundle;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

use Doctrine\Bundle\DoctrineBundle\DependencyInjection\Compiler\DoctrineOrmMappingsPass;

class JuweliereProductBundle extends Bundle
{
    public function getPath(): string
    {
        return \dirname(__DIR__);
    }

    public function build(ContainerBuilder $container)
    {
        /*
         * To extend the bundle to work with mongoDB and couchDB you can follow this tutorial
         * http://symfony.com/doc/current/doctrine/mapping_model_classes.html
         * */

        parent::build($container);
        $ormCompilerClass = '\Doctrine\Bundle\DoctrineBundle\DependencyInjection\Compiler\DoctrineOrmMappingsPass';

        if (class_exists($ormCompilerClass))
        {
            $namespaces = array( 'Juweliere\ProductBundle\Entity' );
            $directories = array( realpath(__DIR__.'/Entity') );
            $managerParameters = array();
            $enabledParameter = false;
            $aliasMap = array('Juweliere\ProductBundle' => 'Juweliere\ProductBundle\Entity');
            $container->addCompilerPass(
                DoctrineOrmMappingsPass::createAnnotationMappingDriver(
                    $namespaces,
                    $directories,
                    $managerParameters,
                    $enabledParameter,
                    $aliasMap
                )
            );
        }
    }
}