<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('juweliere_product');

        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('prefix')->defaultValue('/produkte')->end()
            ->end() // prefix
            ->children()
                ->scalarNode('search_uri')->defaultValue('/suche')->end()
            ->end() // search_uri
            ->children()
                ->arrayNode('redirect')
                    ->children()
                        ->scalarNode('notavailable')->end()
                    ->end()
                ->end() // redirect
                ->arrayNode('base_url')
                    ->children()
                        ->scalarNode('decorator')->end()
                    ->end()
                ->end() // base_url
                ->arrayNode('authorization')
                    ->children()
                        ->scalarNode('token')->end()
                    ->end()
                ->end() // authorization
                ->arrayNode('template')
                    ->children()
                        ->scalarNode('device_detection')->end()
                        ->scalarNode('description_twocolumns')->end()
                    ->end()
                ->end() // template
                ->arrayNode('log')
                    ->children()
                        ->scalarNode('path')->end()
                        ->scalarNode('level')->end()
                    ->end()
                ->end() // log
            ->end();
        return $treeBuilder;
    }
}
