<?php

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereProductExtension extends Extension
{
    /**
     * @param array $configs
     * @param ContainerBuilder $container
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__ . '/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        array_walk(
            $config,
            array($this, 'setParameters'),
            array('parentKey' => $this->getAlias(), 'container' => $container)
        );

        foreach ($config as $key => $value) {
            $container->setParameter('juweliere_product'.$key, $value);
        }


//        $definition = $container->getDefinition('Juweliere\ProductBundle\Decorator\DecoratorApi');
//        $definition->replaceArgument(1, $config['base_url']['decorator']);
//        $definition->replaceArgument(2, $config['authorization']['token']);
//        $definition->replaceArgument(3, $config['log']['path']);
//        $definition->replaceArgument(4, $config['log']['level']);
//
//        $definition = $container->getDefinition('Juweliere\ProductBundle\ElasticSearch\ElasticParser');
//        $definition->replaceArgument(1, $config['base_url']['decorator']);
//        $definition->replaceArgument(2, $config['authorization']['token']);
//        $definition->replaceArgument(3, $config['log']['path']);
//        $definition->replaceArgument(4, $config['log']['level']);
//
//        $definition = $container->getDefinition('Juweliere\ProductBundle\ElasticSearch\ElasticProductsParser');
//        $definition->replaceArgument(2, $config['base_url']['decorator']);
//        $definition->replaceArgument(3, $config['authorization']['token']);
//        $definition->replaceArgument(4, $config['log']['path']);
//        $definition->replaceArgument(5, $config['log']['level']);
//
//        $definition = $container->getDefinition('Juweliere\ProductBundle\Controller\ProductController');
//        $definition->replaceArgument(0, $config['redirect']['notavailable']);
//        $definition->replaceArgument(2, $config['base_url']['decorator']);
//
//        $definition = $container->getDefinition('Juweliere\ProductBundle\Service\TemplateProvider');
//        $definition->setArgument(0, $config['template']['device_detection']);
//
//        $definition = $container->getDefinition('Juweliere\ProductBundle\Service\ProductDataHelper');
//        $definition->setArgument(0, $config['template']['description_twocolumns']);

//        dd($config);
    }

    public function setParameters($value, $key, $params): void
    {
        $parameterName = $params['parentKey'].'.'.$key;
        $params['container']->setParameter($parameterName, $value);
        if (is_array($value)) {
            array_walk($value, array($this, 'setParameters'),
                array(
                    'parentKey' => $parameterName,
                    'container' => $params['container'],
                )
            );
        }
    }
}
