<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;

use Symfony\Component\HttpFoundation\Request;

class TemplateProvider implements TemplateProviderInterface
{
    public function __construct(private bool $useDeviceDetection = false)
    {
    }

    public function getRelatedProducts(Request $request, $small = false): string
    {
        $template = '@JuweliereProduct/pages/product/_related';

        if ($this->useDeviceDetection) {
            $device = $request->get('device');

            $template = match ($device) {
                'tablet' => '@JuweliereProduct/pages/product/tablet/_related',
                'mobile' => '@JuweliereProduct/pages/product/mobile/_related',
                default => '@JuweliereProduct/pages/product/desktop/_related',
            };
        }

        if ($small) {
            $template .= "_small";
        }

        $template .= ".html.twig";

        return $template;
    }

    public function getProductPage(Request $request): string
    {
        $template = '@JuweliereProduct/pages/product.html.twig';

        if ($this->useDeviceDetection) {
            $device = $request->get('device');

            $template = match ($device) {
                'mobile' => '@JuweliereProduct/pages/product/mobile/_product.html.twig',
                'tablet' => '@JuweliereProduct/pages/product/tablet/_product.html.twig',
                default => '@JuweliereProduct/pages/product/desktop/_product.html.twig',
            };
        }

        return $template;
    }
}
