<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;

use Carbon\Carbon;

class ProductPriceHelper
{
    /**
     * @param array|null $product
     * @param bool $currencyAsText
     * @return array|null
     */
    public function getPrice(?array $product, bool $currencyAsText = false): ?array
    {
        if (!$product) {
            return null;
        }

        $showPrice = (bool)$product['showPrice'];
        if (!$showPrice) {
            return null;
        }

        $rrp = isset($product['rrp']) ? (float)$product['rrp'] : null;
        $currencySymbol = $currencyAsText ? 'EUR' : '€';

        $data = [
            'rrp' => [
                'value' => $rrp,
                'currency' => $currencySymbol,
            ],
            'specialPrice' => null,
            'actualPrice' => [
                'value' => $rrp,
                'currency' => '€',
            ],
        ];

        $specialsPrices = isset($product['prices']) && sizeof($product['prices']) > 0 ? $product['prices'] : null;

        if ($specialsPrices) {
            foreach ($specialsPrices as $specialsPrice) {
                $validFrom = new Carbon($specialsPrice['validFrom']);
                $validThrough = new Carbon($specialsPrice['validThrough']);

                $now = Carbon::now();

                if ($validFrom->lte($now) && $validThrough->gte($now)) {
                    if ($specialsPrice['currency'] === $data['actualPrice']['currency']) {
                        $data['specialPrice'] = [
                            'value' => (float)$specialsPrice['price'],
                            'currency' => $specialsPrice['currency'],
                        ];

                        $data['actualPrice']['value'] = (float)$specialsPrice['price'];
                    }
                }
            }
        }

        return $data;
    }
}
