<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Controller\Website;

use Juweliere\ProductBundle\ElasticSearch\ElasticProductsParser;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class SearchController extends AbstractController
{
    private ElasticProductsParser $productsParser;
    private HttpClientInterface $rolexClient;

    public function __construct(ElasticProductsParser $productsParser, HttpClientInterface $rolexClient)
    {
        $this->productsParser = $productsParser;
        $this->rolexClient = $rolexClient;
    }

    /**
     * @Route("%juweliere_product.search_uri%", name="search", options={"expose"=true})
     *
     * @param Request $request
     *
     * @return Response
     *
     * @throws TransportExceptionInterface
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     */
    public function search(Request $request): Response
    {
        $response = $this->rolexClient->request('GET', '/api/keywords.json');
        $keywordList = [];

        if ($response->getStatusCode() === 200) {
            foreach ($response->toArray() as $item) {
                $keywordList[] = $item['keyword'];
            }
        }

        $keywordList = array_unique($keywordList);

        $query = $request->query->get('q');
        $queryParts = [];

        if ($query) {
            $queryParts = explode(" ", $query);
        }

        foreach ($queryParts as $queryPart) {
            if (in_array(strtolower($queryPart), $keywordList)) {
                return new RedirectResponse('/rolex');
            }
        }

        $hits = $this->productsParser->search($query);

        return $this->render('pages/search.html.twig', [
            'result' => $hits,
            'query' => $query,
        ]);
    }
}
