<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Controller\Website;

use Juweliere\ProductBundle\ElasticSearch\ElasticProductsParser;
use Juweliere\ProductBundle\ElasticSearch\ElasticWidgetParser;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class WidgetController extends AbstractController
{
    public function __construct(
        private ElasticProductsParser $productsParser,
        private ElasticWidgetParser $widgetParser
    )
    {
    }

    /**
     * @param string $uuid
     * @return Response
     */
    #[Route("widgets/{uuid}", name: "widgets_show", options: ["expose" => true])]
    public function show(string $uuid): Response
    {
        $widget = $this->widgetParser->getSingleWidget($uuid);
        $type = $widget['type']['slug'] ?? null;
        $template = $this->getWidgetTemplate($type);

        $response = $this->render($template, [
            'widget' => $widget,
            'type' => $type,
            'products' => $this->productsParser->getProductArray($widget['items']),
        ]);

        $response->setPublic();
        $response->setMaxAge(60);

        return $response;
    }

    /**
     * @param string|null $type
     * @return string|null
     */
    private function getWidgetTemplate(?string $type): ?string
    {
        $template = null;

        if ($type) {
            $template = match ($type) {
                '3_products' => 'widgets/three-products.html.twig',
                'product_carousel' => 'widgets/product-carousel.html.twig',
                default => 'widgets/four-products.html.twig',
            };
        }

        return $template;
    }
}
