<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\ElasticSearch;

use Juweliere\ProductBundle\Decorator\DecoratorClientInterface;

class ElasticWidgetParser
{
    public const WIDGET_URI = '/api/elastic/widgets';

    public function __construct(private DecoratorClientInterface $decoratorClient)
    {
    }

    /**
     * @param string $uuid
     * @return array|null
     */
    public function getSingleWidget(string $uuid): ?array
    {
        $uri = sprintf('%s/%s', self::WIDGET_URI, $uuid);

        return $this->decoratorClient->get($uri);
    }
}
