<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Admin\Helper;

use Juweliere\ProductBundle\Decorator\DecoratorClientInterface;

abstract class AbstractDecoratorSelect
{
    public const SELECT_TYPE_WIDGET = 'widget';
    public const SELECT_TYPE_SELECTION = 'selection';
    public const SELECT_TYPE_PRODUCT_LIST = 'productlist';

    public function __construct(protected DecoratorClientInterface $decoratorClient)
    {
    }

    public function getCollection(string $type): array
    {
        $uri = match ($type) {
            self::SELECT_TYPE_WIDGET => WidgetSelect::API_WIDGET_SELECTION_URI,
            self::SELECT_TYPE_PRODUCT_LIST => ProductListSelect::API_PRODUCT_LIST_SELECTION_URI,
            default => ProductSelectionSelect::API_PRODUCT_SELECTION_URI,
        };

        $content = $this->decoratorClient->get($uri);

        if (empty($content)) {
            return [];
        }
        $values = [];

        $values[] = [
            'name' => '',
            'title' => 'Bitte auswählen',
        ];

        foreach ($content['hydra:member'] as $item) {
            if (!isset($item['id']) ||!isset($item['name'])) {
                continue;
            }

            $values[] = [
                'name' => $item['id'],
                'title' => $item['name'],
            ];
        }

        return $values;
    }
}
