<?php

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereProductExtension extends Extension
{
    /**
     * @param array $configs
     * @param ContainerBuilder $container
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__ . '/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        array_walk(
            $config,
            array($this, 'setParameters'),
            array('parentKey' => $this->getAlias(), 'container' => $container)
        );

        foreach ($config as $key => $value) {
            $container->setParameter('juweliere_product'.$key, $value);
        }
        
    }

    public function setParameters($value, $key, $params): void
    {
        $parameterName = $params['parentKey'].'.'.$key;
        $params['container']->setParameter($parameterName, $value);
        if (is_array($value)) {
            array_walk($value, array($this, 'setParameters'),
                array(
                    'parentKey' => $parameterName,
                    'container' => $params['container'],
                )
            );
        }
    }
}
