<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;

use Symfony\Component\HttpFoundation\Request;

class TemplateProvider implements TemplateProviderInterface
{
    public function getRelatedProducts(Request $request, bool $small = false): string
    {
        $template = '@JuweliereProduct/pages/product/_related';

        if ($small) {
            $template .= "_small";
        }

        $template .= ".html.twig";

        return $template;
    }

    public function getProductPage(Request $request): string
    {
        $template = '@JuweliereProduct/pages/product.html.twig';

        return $template;
    }

    public function getAddToCart(): string
    {
        $template = '@JuweliereProduct/pages/product/_add_to_cart.html.twig';

        return $template;
    }
}
