# juweliere/product-bundle

A bundle to provide a service for handling product data via related online decorator.

## Installation

Execute the following [composer](https://getcomposer.org/) command to add the bundle to the dependencies of your
project:

```bash
composer require juweliere/product-bundle
```

Configuration should be done automatically by Symfony Flex, if that fails for some reason you have to do it manually:

### Configure JuwelierProductBundle

```yml
# config/packages/juweliere_product.yaml

juweliere_product:
  base_url:
    decorator: '%env(JUWELIERE_PRODUCT_BASE_URL_DECORATOR)%'
  authorization:
    token: '%env(JUWELIERE_PRODUCT_AUTHORIZATION_TOKEN)%'
```

```yml
# config/packages/routes/juweliere_product.yaml

juweliere_product:
  resource: "@JuweliereProductBundle"
  type: annotation
```

### Create env variables

```yml
# .env

JUWELIERE_PRODUCT_BASE_URL_DECORATOR=https://test.online-dekorateur.de/
JUWELIERE_PRODUCT_AUTHORIZATION_TOKEN=xxx
```

### Add required bundles to AbstractKernel

These bundles need to be registered:

```php
/* config/bundles.php */

Juweliere\ProductBundle\JuweliereProductBundle::class => ['all' => true],
```

## Usage

### Routes
Bundle provides different routes (prefixed with `/product`). See `src/Controller/ProductController`