<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Session;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

class SessionManager
{
    const SESSION_LAST_SEEN = "lastseen";

    public function __construct(protected SessionInterface $session)
    {
    }

    public function setPage(string $uuid, int $page)
    {
        $entry = $this->getEntry($uuid);

        $entry['page'] = $page;
        $this->session->set($uuid, $entry);
    }

    public function setLimit(string $uuid, int $limit)
    {
        $entry = $this->getEntry($uuid);

        $entry['limit'] = $limit;
        $this->session->set($uuid, $entry);
    }

    public function setSorting(string $uuid, string $sorter, string $dir = 'asc')
    {
        $entry = $this->getEntry($uuid);

        $entry['sort'] = $sorter;
        $entry['dir'] = $dir;
        $this->session->set($uuid, $entry);
    }

    public function getEntry($uuid)
    {
        if ($this->session->has($uuid)) {
            return $this->session->get($uuid, []);
        }

        return null;
    }

    public function getLastSeenProducts(array $product, int $limit = 4): array
    {
        $lastSeenProducts = array();
        $newLastSeenProducts = array();
        $count = 0;

        /** @var array $attributes */
        $attributes = array(
            "sku",
            "reference",
            "qty",
            "image",
            "brand",
            "name",
            "showPrice",
            "rrp"
        );

        if ($this->session->has(self::SESSION_LAST_SEEN)) {
            $lastSeenProducts = $this->session->get(self::SESSION_LAST_SEEN);
        }

        foreach ($lastSeenProducts as $key => $lastSeenProduct) {
            if ($count > $limit) {
                break;
            }
            if ($lastSeenProduct["sku"] === $product["sku"]) {
                continue;
            }
            $newLastSeenProducts[] = $lastSeenProduct;
            $count++;
        }

        $productDataFiltered = array_intersect_key($product, array_flip($attributes));

        array_unshift($newLastSeenProducts, $productDataFiltered);

        $this->session->set(self::SESSION_LAST_SEEN, $newLastSeenProducts);
        $this->session->save();

        array_shift($newLastSeenProducts);

        return $newLastSeenProducts;
    }
}
