<?php

namespace Juweliere\ProductBundle\Entity;

use Juweliere\ProductBundle\Repository\CUstomPDPRepository;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;

/**
 * @ORM\Entity(repositoryClass=NewsletterRepository::class)
 */
class CustomPDP
{
    use TimestampableEntity;

    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private ?int $id = 0;

    /**
     * @ORM\Column(type="string", length=128)
     */
    private string $type;

    /**
     * @ORM\Column(type="string")
     */
    private $propertyValue;

    /**
     * @ORM\Column(type="string")
     */
    private $pageId;

    /**
     * @ORM\Column(type="boolean")
     */
    private $isActive = true;

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getPropertyValue()
    {
        return $this->propertyValue;
    }

    /**
     * @param mixed $propertyValue
     */
    public function setPropertyValue($propertyValue): void
    {
        $this->propertyValue = $propertyValue;
    }

    /**
     * @return mixed
     */
    public function getPageId()
    {
        return $this->pageId;
    }

    /**
     * @param mixed $pageId
     */
    public function setPageId($pageId): void
    {
        $this->pageId = $pageId;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->isActive();
    }

    /**
     * @param bool $isActive
     */
    public function setIsActive(bool $isActive): void
    {
        $this->isActive = $isActive;
    }

}
