<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Admin\Helper;

use Juweliere\ProductBundle\Decorator\DecoratorClientInterface;

class BrandSelect implements ApiSelectInterface
{
    public const API_BRAND = '/api/juweliere-brands?isEnabled=true&order[name]=asc&limit=1000';

    public function __construct(protected DecoratorClientInterface $decoratorClient)
    {
    }
    public function getValues(): array
    {
        $content = $this->decoratorClient->get(self::API_BRAND);
        if (empty($content)) {
            return [];
        }

        $values = [];

        $values[] = [
            'name' => '',
            'title' => 'Bitte auswählen',
        ];

        foreach ($content['hydra:member'] as $item) {
            if (!isset($item['code']) ||!isset($item['name'])) {
                continue;
            }

            $values[] = [
                'name' => $item['code'],
                'title' => $item['name'],
            ];
        }

        return $values;
    }
}
