<?php

namespace Juweliere\ProductBundle\EventSubscriber;

use Juweliere\ProductBundle\Entity\CustomPDP;
use Juweliere\ProductBundle\Repository\CustomPDPRepository;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Log\LoggerInterface;
use Sulu\Bundle\ActivityBundle\Domain\Event\DomainEvent;
use Sulu\Bundle\PageBundle\Domain\Event\PageCreatedEvent;
use Sulu\Bundle\PageBundle\Domain\Event\PageModifiedEvent;
use Sulu\Bundle\PageBundle\Domain\Event\PagePublishedEvent;
use Sulu\Bundle\PageBundle\Domain\Event\PageRemovedEvent;
use Sulu\Bundle\PageBundle\Domain\Event\PageUnpublishedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Email;

class CustomPdpSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private EntityManagerInterface $em,
        private CustomPDPRepository $customPDPRepository,
        private LoggerInterface $custompdpLogger
    ) {
        $this->custompdpLogger->info("init custom pdp subscriber");
    }

    public static function getSubscribedEvents()
    {
        return [
//            PageCreatedEvent::class => 'updateCustomPdp',
            PageModifiedEvent::class => 'updateCustomPdp',
            PageCreatedEvent::class => 'updateCustomPdp',
            PageRemovedEvent::class => 'removeCustomPdp',
            PageUnpublishedEvent::class => 'unpublishCustomPdp',
            PagePublishedEvent::class => 'updateCustomPdp',
        ];
    }

    public function removeCustomPdp(PageRemovedEvent $event): void
    {
        $this->custompdpLogger->debug($event->getEventType());
        $this->disableCustomPDP($event->getResourceId());
    }

    public function unpublishCustomPdp(PageUnpublishedEvent $event): void
    {
        $this->custompdpLogger->debug($event->getEventType());
        $this->disableCustomPDP($event->getPageDocument()->getUuid());
    }

    private function disableCustomPDP($pageId) {
        try {
            $customPDP = $this->customPDPRepository->findOneBy(["pageId" => $pageId]);

            if (!is_null($customPDP)) {
                $this->custompdpLogger->info("Disable page " . $pageId);
                $customPDP->setIsActive(false);
                $this->em->persist($customPDP);
                $this->em->flush();
            }

        } catch (\Throwable $e) {
            $this->custompdpLogger->error($e->getMessage());
        }
    }

    public function updateCustomPdp(DomainEvent $event): void
    {
        $this->custompdpLogger->debug($event->getEventType());
        $structure = $event->getPageDocument()->getStructure()->toArray();

        $pageId = $event->getPageDocument()->getUuid();

        try {
            if ('custompdp' === $event->getPageDocument()->getStructureType()) {
                $customPDP = $this->customPDPRepository->findOneBy(["pageId" => $pageId]);

                if (is_null($customPDP)) {
                    $customPDP = new CustomPDP();
                    $customPDP->setPageId($pageId);
                }

                $type = $structure["custompdp_type"];

                $customPDP->setType($type);
                $customPDP->setIsActive(true);

                $this->custompdpLogger->debug("Type:" . $type);

                if ($type === "sku" && !empty(trim($structure["sku"]))) {
                    $this->custompdpLogger->debug($structure["sku"]);
                    $customPDP->setPropertyValue($structure["sku"]);

                } elseif ($type === "productline" && !empty(trim($structure["productline"]))) {
                    $this->custompdpLogger->debug($structure["productline"]);
                    $customPDP->setPropertyValue($structure["productline"]);

                } elseif ($type === "brand" && !empty(trim($structure["brand"]))) {
                    $this->custompdpLogger->debug($structure["brand"]);
                    $customPDP->setPropertyValue($structure["brand"]);

                } elseif ($type === "productgroup") {
                    $this->custompdpLogger->debug($structure["productgroup"]);
                    $customPDP->setPropertyValue($structure["productgroup"]);
                } elseif ($type === "default") {
                    $this->custompdpLogger->debug($structure["brand"]);
                    $customPDP->setPropertyValue("");
                }

                $this->em->persist($customPDP);
                $this->em->flush();
            }
        } catch (\Throwable $e) {
            $this->custompdpLogger->error($e->getMessage());
        }


//
//        var_dump($structure["blocks"]);
//        die();
//        if (isset($structure["blocks"]) && $structure["blocks"][0]["type"] === "product_selection") {
//            $this->custompdpLogger->info("SELECTION " . $structure["blocks"][0]["selection_uuid"]);
//        }
    }
}
