<?php

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('juweliere_product');

        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('prefix')->defaultValue('/produkte')->end()
            ->end() // prefix
            ->children()
                ->scalarNode('search_uri')->defaultValue('/suche')->end()
            ->end() // search_uri
            ->children()
                ->scalarNode('cdn')->defaultValue('https://bilder.juweliere.de/cdn')->end()
            ->end()
            ->children()
                ->arrayNode('redirect')
                    ->children()
                        ->scalarNode('enabled')->defaultFalse()->end()
                        ->scalarNode('notavailable')->defaultNull()->end()
                    ->end()
                ->end() // redirect

                ->arrayNode('base_url')
                    ->children()
                        ->scalarNode('decorator')->defaultValue('%decorator_base_url%')->end()
                        ->scalarNode('decorator_public')->defaultValue('%decorator_base_url_public%')->end()
                    ->end()
                ->end() // base_url
                ->arrayNode('authorization')
                    ->children()
                        ->scalarNode('token')->defaultValue('%decorator_authorization_token%')->end()
                    ->end()
                ->end() // authorization
                ->arrayNode('template')
                    ->children()
                        ->scalarNode('description_twocolumns')->defaultFalse()->end()
                        ->booleanNode('last_visited_products')->defaultFalse()->end()
                    ->end()
                ->end() // template
                ->arrayNode('log')
                    ->children()
                        ->scalarNode('path')->defaultValue('%kernel.logs_dir%/')->end()
                        ->scalarNode('level')->defaultValue('info')->end()
                    ->end()
                ->end() // log
            ->end()
        ;

        return $treeBuilder;
    }
}
