<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;

use Juweliere\ProductBundle\Admin\Helper\ProductlineSelect;
use Juweliere\ProductBundle\Repository\CustomPDPRepository;
use Symfony\Component\HttpFoundation\Request;

class TemplateProvider implements TemplateProviderInterface
{
    private CustomPDPRepository $customPDPRepository;

    public function __construct(
        CustomPDPRepository $customPDPRepository
    )
    {
        $this->customPDPRepository = $customPDPRepository;
    }

    public function getRelatedProducts(Request $request, bool $small = false): string
    {
        $template = '@JuweliereProduct/pages/product/_related';

        if ($small) {
            $template .= "_small";
        }

        $template .= ".html.twig";

        return $template;
    }

    public function getCustomPDP($product, $attributes): ?string {
        // Check for custom pdp for SKU
        $customPDP = $this->customPDPRepository->findOneBy([
            "type" => "sku",
            "isActive" => true,
            "propertyValue" => $product["sku"]
        ]);

        // Check for custom pdp for collection
        if (is_null($customPDP) && isset($product["productline"])) {
            $customPDP = $this->customPDPRepository->findOneBy([
                "type" => "productline",
                "isActive" => true,
                "propertyValue" => $product["brandCode"] . ProductlineSelect::BRAND_LINE_CONCAT . $product["productline"]
            ]);
        }

        // Check for custom pdp for brand
        if (is_null($customPDP)) {
            foreach ($attributes as $attribute) {
                if ($attribute["attributeCode"] == "juweliere_brand") {

                    $customPDP = $this->customPDPRepository->findOneBy([
                        "type" => "brand",
                        "isActive" => true,
                        "propertyValue" => $attribute["valueCode"]
                    ]);

                    break;
                }
            }
        }

        // Check for custom pdp for brand
        if (is_null($customPDP)) {
            foreach ($attributes as $attribute) {
                if ($attribute["attributeCode"] == "product_group") {

                    $customPDP = $this->customPDPRepository->findOneBy([
                        "type" => "productgroup",
                        "isActive" => true,
                        "propertyValue" => $attribute["valueCode"]
                    ]);

                    break;
                }
            }
        }

        // Check for DEFAULT custom pdp
        if (is_null($customPDP)) {
            $customPDP = $this->customPDPRepository->findOneBy([
                "type" => "default",
                "isActive" => true
            ]);
        }

        if (!is_null($customPDP)) {
            return $customPDP->getPageId();
        }

        return null;
    }

    public function getProductPage($customPDP): string
    {
        if (empty($customPDP)) {
            return '@JuweliereProduct/pages/product.html.twig';
        }

        return 'pages/custompdp.html.twig';
    }

    public function getAddToCart(): string
    {
        $template = '@JuweliereProduct/pages/product/_add_to_cart.html.twig';

        return $template;
    }
}
