<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Controller\Website;

use Juweliere\ProductBundle\ElasticSearch\ElasticProductsParser;
use Juweliere\ProductBundle\ElasticSearch\ElasticWidgetParser;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class WidgetController extends AbstractController
{

    public function __construct(
        private ElasticProductsParser $productsParser,
        private ElasticWidgetParser $widgetParser,
        private LoggerInterface $logger
    )
    {
    }

    /**
     * @param Request $request
     * @param string $uuid
     * @return Response
     */
    #[Route("widgets/{uuid}", name: "widgets_show", options: ["expose" => true])]
    public function show(Request $request, string $uuid): Response
    {

        try {
            $widget = $this->widgetParser->getSingleWidget($uuid);
            $type = $request->get('type', $widget['type']['slug'] ?? null);
            $blockIndex = $request->get('index', 1);
            $template = $this->getWidgetTemplate($type);

            $response = $this->render($template, [
                'widget' => $widget,
                'type' => $type,
                'blockIndex' => $blockIndex,
                'products' => $this->productsParser->getProductArray($widget['items']),
            ]);

        } catch (\Throwable $e) {
            $this->logger->error("Widget Error: " . $e->getMessage() . " - " . $e->getTraceAsString());
            $response = new Response();
        }

        $response->setPublic();
        $response->setMaxAge(60);


        return $response;
    }

    /**
     * @param string|null $type
     * @return string|null
     */
    private function getWidgetTemplate(?string $type): ?string
    {
        if ($type) {
            return sprintf("@JuweliereProduct/widgets/%s.html.twig", $type);
        }

        return "@JuweliereProduct/widgets/four_products.html.twig";
    }
}
