<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Service;

use Sulu\Bundle\PageBundle\Document\PageDocument;
use Sulu\Component\DocumentManager\Collection\QueryResultCollection;
use Sulu\Component\DocumentManager\DocumentManagerInterface;
use Sulu\Component\DocumentManager\Query\Query;

class NotFoundHelper
{
    public function __construct(private DocumentManagerInterface $documentManager)
    {
    }

    public function getAlternateBrandPage($sku)
    {
        $productGroups = ["uhren", "schmuck"];

        foreach ($productGroups as $productGroup) {
            $brandPage = $this->getBrandPage($sku, $productGroup);
            if ($brandPage) {
                return $brandPage;
            }
        }

        return null;
    }

    private function getBrandPage($sku, $productGroup) {
        /** @var Query $query */
        $query = $this->documentManager->createQuery('SELECT * FROM [nt:unstructured] WHERE [jcr:path] LIKE "%' . $productGroup . '%" ORDER BY [jcr:path] DESC');

        /** @var QueryResultCollection $documents */
        $documents = $query->execute();

        /** @var $document */
        foreach ($documents as $document) {
            try {
                /** @var PageDocument $document */
                if ($document instanceof PageDocument &&
                    $document->getWorkflowStage() === 2) {

                    $url = $document->getStructure()->getProperty("url")->getValue();
                    $urlParts = explode("/", $url);

                    if (preg_match("/" . end($urlParts) .  "/", $sku)) {

//                        var_dump($document->getPath());
//                        var_dump($document->getUuid());
//                        var_dump($document->getStructureType());
//                        var_dump($document->getAuthored()->format("Y-m-d"));
//                        var_dump($document->getChanged()->format("Y-m-d"));
//                        var_dump($document->getTitle());
//                        var_dump($document->getPublished());
//                        var_dump($document->getWorkflowStage());
//                        var_dump($document->getLocale());
//                        die();

                        return $url;
                    }
                };
            } catch (\Throwable $e) {
//                dd($e->getMessage());
            }
        }

        /** @var $document */
        foreach ($documents as $document) {
            try {
                /** @var PageDocument $document */
                if ($document instanceof PageDocument &&
                    $document->getWorkflowStage() === 2) {

                    $url = $document->getStructure()->getProperty("url")->getValue();
                    $urlParts = explode("/", $url);

                    $subUrlParts = explode("-", end($urlParts));

                    if (count($subUrlParts) > 1) {
                        foreach ($subUrlParts as $subUrlPart) {

                            if (preg_match("/" . $subUrlPart . "/", $sku)) {

                                //                        var_dump($document->getPath());
                                //                        var_dump($document->getUuid());
                                //                        var_dump($document->getStructureType());
                                //                        var_dump($document->getAuthored()->format("Y-m-d"));
                                //                        var_dump($document->getChanged()->format("Y-m-d"));
                                //                        var_dump($document->getTitle());
                                //                        var_dump($document->getPublished());
                                //                        var_dump($document->getWorkflowStage());
                                //                        var_dump($document->getLocale());
                                //                        die();

                                return $url;
                            }
                        }
                    }
                };
            } catch (\Throwable $e) {
//                dd($e->getMessage());
            }
        }

        return null;
    }
}
