<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Session;

class CatalogFilterManager extends SessionManager
{
    const ON_STOCK_FILTER = "stock";

    public function addFilter(string $uuid, array $filter): void
    {
        $entry = $this->getEntry($uuid);

        $key = $filter['code'];
        $value = $filter['value'];

        if ($entry) {
            if (isset($entry['filters']) && isset($entry['filters'][$key]) && !is_array($entry['filters'][$key])) {
                unset($entry['filters'][$key]);
            }

            if (!isset($entry['filters'][$key]) ||
                !in_array($value, $entry['filters'][$key])) {
                $entry['filters'][$key][] = $value;
            }

        } else {
            $entry['filters'][$key][] = $value;

        }

        $this->session->set($uuid, $entry);
    }

    public function removeFilter(string $uuid, array|string $filter): void
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            if (isset($entry['filters'])) {
                if (key_exists($filter, $entry['filters'])) {
                    unset($entry['filters'][$filter]);
                }

                $this->session->set($uuid, $entry);
            }
        }
    }

    public function removeOption(string $uuid, array|string $filter, int|float|string $option): void
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            if (isset($entry['filters'])) {
                if (key_exists($filter, $entry['filters'])) {
                    $key = array_search($option, $entry['filters'][$filter], true);
                    if ($key !== false) {
                        unset($entry['filters'][$filter][$key]);
                    }

                    if (empty($entry['filters'][$filter])) {
                        unset($entry['filters'][$filter]);
                    }
                }

                $this->session->set($uuid, $entry);
            }
        }
    }

    public function removeEntry(string $uuid): bool
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            foreach ($entry['filters'] as $key => $filter) {
                unset($entry['filters'][$key]);
            }

            $this->session->set($uuid, $entry);

            return true;
        }

        return false;
    }

    public function setStockFilter(string $uuid, bool $value = true): bool
    {
        $entry = $this->getEntry($uuid);

        if (!$entry) {
            $entry [self::ON_STOCK_FILTER] = $value;
        } else {
            $entry = [self::ON_STOCK_FILTER => $value];
        }

        $this->session->set($uuid, $entry);

        return true;
    }
}
