<?php

namespace Juweliere\ProductBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereProductExtension extends Extension
{
    /**
     * @throws \Exception
     */
    #[\Override]
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__ . '/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        array_walk(
            $config,
            [$this, 'setParameters'],
            ['parentKey' => $this->getAlias(), 'container' => $container]
        );

        foreach ($config as $key => $value) {
            $container->setParameter('juweliere_product'.$key, $value);
        }
        
    }

    public function setParameters($value, string $key, array $params): void
    {
        $parameterName = $params['parentKey'].'.'.$key;
        $params['container']->setParameter($parameterName, $value);
        if (is_array($value)) {
            array_walk($value, [$this, 'setParameters'],
                ['parentKey' => $parameterName, 'container' => $params['container']]
            );
        }
    }
}
