<?php

namespace Juweliere\ProductBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;

#[ORM\Entity(repositoryClass: NewsletterRepository::class)]
class CustomPDP
{
    use TimestampableEntity;

    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    private ?int $id = 0;

    #[ORM\Column(type: 'string', length: 128)]
    private string $type;

    #[ORM\Column(type: 'string')]
    private $propertyValue;

    #[ORM\Column(type: 'string')]
    private $pageId;

    #[ORM\Column(type: 'boolean')]
    private bool $isActive = true;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getPropertyValue()
    {
        return $this->propertyValue;
    }

    public function setPropertyValue(mixed $propertyValue): void
    {
        $this->propertyValue = $propertyValue;
    }

    /**
     * @return mixed
     */
    public function getPageId()
    {
        return $this->pageId;
    }

    public function setPageId(mixed $pageId): void
    {
        $this->pageId = $pageId;
    }

    public function isActive(): bool
    {
        return $this->isActive();
    }

    public function setIsActive(bool $isActive): void
    {
        $this->isActive = $isActive;
    }

}
