<?php

declare(strict_types=1);

namespace Juweliere\ProductBundle\Admin\Helper;

use Juweliere\ProductBundle\Decorator\DecoratorClientInterface;

class ProductlineSelect implements ApiSelectInterface
{
    public const API_PRODUCTLINE_URI = '/api/productlines';

    public const BRAND_LINE_CONCAT = '#:#';

    public function __construct(protected DecoratorClientInterface $decoratorClient)
    {
    }

    #[\Override]
    public function getValues(): array
    {
        $content = $this->decoratorClient->get(self::API_PRODUCTLINE_URI);
        if (empty($content)) {
            return [];
        }

        $values = [];

        $values[] = [
            'name' => '',
            'title' => 'Bitte auswählen',
        ];

        foreach ($content as $prodcutline) {
            if (!isset($prodcutline['brand_code']) ||!isset($prodcutline['option_code']) ||!isset($prodcutline['name'])) {
                continue;
            }

            $values[] = [
                'name' => $prodcutline['brand_code'] . self::BRAND_LINE_CONCAT . $prodcutline['option_code'],
                'title' => $prodcutline['name'],
            ];
        }

        return $values;
    }
}
