# juweliere.de ProductClonerBundle for Akeneo PIM

This bundle is aimed to offer product clone functionality within Akeneo PIM. It is based on the ProductClonerBundle by Flagbit GmbH & Co. KG

## Functionalities ##
* Clone a product model
* Clone a product or a variant product


## Installation ##
You can install the package with the following command.

``` bash
composer require juweliere/product-cloner-bundle
```

### Enable the bundle ####

Add the bundle to the `config/bundles.php` file:

``` php
<?php

return [
    \Juweliere\Bundle\ProductClonerBundle\JuweliereProductClonerBundle::class => ['all' => true],
    // ...
];
```

#### Import the routing ####
Now that you have activated and configured the bundle, all that is left to do is import the JuweliereProductClonerBundle
routing files.

``` yaml
# config/routes/product_cloner.yml
juweliere_product_cloner:
    resource: "@JuweliereProductClonerBundle/Resources/config/routing.yml"
```

Build and install the new front-end dependencies (new translations, etc.)

``` bash
make cache assets css javascript-prod
```

## How to use it ##
Open a product and there open the **options dialog** at the **right corner**.
You can see it here on the screen:
![Product Model Clone Screen](screens/product_model_clone.png "Product Model Clone Screen")

After clicking on **clone** you will see this **dialog**:
![Product Model Clone Dialog Screen](screens/product_model_clone_dialog.png "Product Model Clone Dialog Screen")

Put in a new **product code** and click on **save**. After that check if all the data is correct for the new product.

### Configuration

You don't need to configure this bundle by default.
The default behaviour is to clone all product or product model attributes except the unique attributes.
In addition, you can specify a blacklist of attributes that shouldn't be cloned:

``` yaml
juweliere_product_cloner:
    attribute_blacklist:
        - your_attribute_code1
        - your_attribute_code2
        - your_attribute_code3
        ...
```

## Akeneo Compatibility ##

This extension supports the latest Akeneo PIM CE/EE stable versions:

* 2.3 (LTS)
* 3.0 (LTS)
* 3.2 (LTS)
* 4.0
* 5.0

## License ##

The JuweliereProductClonerBundle is licensed under the MIT License - see the [LICENSE](LICENSE) file for details
