<?php


namespace Juweliere\ApiRequestcounterBundle\EventListener;

use Psr\Log\LoggerInterface;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Component\HttpKernel\Event\TerminateEvent;

class TerminateListener
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var string
     */
    private $serverUrl;

    /**
     * @var string
     */
    private $instance;

    /**
     * TerminateListener constructor.
     * @param LoggerInterface $logger
     */
    public function __construct(LoggerInterface $dechefLogger, $serveUrl, $instance)
    {
        $this->logger = $dechefLogger;
        $this->serverUrl = $serveUrl;
        $this->instance = $instance;
    }

    public function onKernelTerminate(TerminateEvent $event)
    {
        $code = $event->getResponse()->getStatusCode();
        $method = $event->getRequest()->getMethod();

        $service = $event->getRequest()->attributes->get("_route");
        $juwId = $event->getResponse()->headers->get('X-Jeweller-Id', "UNKNOWN");

        $client = HttpClient::createForBaseUri($this->serverUrl);
        $client->request(
            "POST",
            "/",
            [
                'json' => [
                    'instance' => $this->instance,
                    'method' => $method,
                    'service' => $service,
                    'http_code' => $code,
                    'juwid' => $juwId
                ]
            ]
        );

        $this->logger->debug("Terminate kernel event " . $this->serverUrl . " " . $this->instance . " " . $method . " " . $service . " " . $code . " " . $juwId);
    }
}