<?php

namespace Juweliere\RequestcounterBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereRequestcounterExtension extends Extension
{
    /**
     * @param array            $configs
     * @param ContainerBuilder $container
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__.'/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $definition = $container->getDefinition('Juweliere\RequestcounterBundle\EventListener\TerminateListener');
        $definition->replaceArgument(1, $config['server']['url']);
        $definition->replaceArgument(2, $config['instance']);
        $definition->replaceArgument(3, $config['env']);
    }
}