<?php


namespace Juweliere\RequestcounterBundle\EventListener;

use Psr\Log\LoggerInterface;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Component\HttpKernel\Event\TerminateEvent;

class TerminateListener
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var string
     */
    private $serverUrl;

    /**
     * @var string
     */
    private $instance;

    /**
     * @var string
     */
    private $env;

    /**
     * TerminateListener constructor.
     * @param LoggerInterface $dechefLogger
     * @param $serveUrl
     * @param $instance
     * @param $env
     */
    public function __construct(LoggerInterface $dechefLogger, $serveUrl, $instance, $env)
    {
        $this->logger = $dechefLogger;
        $this->serverUrl = $serveUrl;
        $this->instance = $instance;
        $this->env = $env;
    }

    public function onKernelTerminate(TerminateEvent $event)
    {
        $code = $event->getResponse()->getStatusCode();
        $method = $event->getRequest()->getMethod();

        $service = $event->getRequest()->attributes->get("_route");
        $juwId = $event->getResponse()->headers->get('X-Jeweller-Id', "UNKNOWN");

        $client = HttpClient::createForBaseUri($this->serverUrl);
        $client->request(
            "POST",
            "/",
            [
                'json' => [
                    'instance' => $this->instance,
                    'env' => $this->env,
                    'method' => $method,
                    'service' => $service,
                    'http_code' => $code,
                    'juwid' => $juwId
                ]
            ]
        );

        $this->logger->debug("Terminate kernel event " . $this->serverUrl . " " . $this->instance . " " . $this->env . " " . $method . " " . $service . " " . $code . " " . $juwId);
    }
}