<?php

declare(strict_types=1);

namespace Juweliere\SyliusBundle\Controller\Website;

use Exception;
use Juweliere\CoreBundle\ElasticSearch\ElasticProductsParser;
use Juweliere\CoreBundle\Service\ProductPriceHelper;
use Juweliere\SyliusBundle\Service\SyliusProductParser;
use Psr\Cache\InvalidArgumentException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

class ProductController extends AbstractController
{
    /**
     * @Route("/products/{sku}/cart", name="juweliere_catalog_product_add_to_cart", options={"expose"=true}, requirements={"sku"=".+"}, options={"expose"=true})
     *
     * @param string $sku
     * @param ElasticProductsParser $productsParser
     * @param SyliusProductParser $syliusProductParser
     * @param ProductPriceHelper $priceHelper
     *
     * @return Response
     *
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws InvalidArgumentException
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     * @throws Exception
     */
    public function addToCart(string $sku, ElasticProductsParser $productsParser, SyliusProductParser $syliusProductParser, ProductPriceHelper $priceHelper): Response
    {
        $product = $productsParser->getSingleProduct($sku, false);

        $isSaleable = false;
        if (boolval($product['isEnabled'])
            && boolval($product['isSaleable'])
            && $priceHelper->getPrice($product)
            && intval($product['qty']) > 0
        ) {
            $isSaleable = true;
        }

        $response = $this->render('pages/product/_add_to_cart.html.twig', [
            'product' => $product,
            'is_saleable' => $isSaleable,
            'sylius_product_id' => $syliusProductParser->getProductId($sku),
            'price' => $priceHelper->getPrice($product),
        ]);
        $response->setPublic();
        $response->setSharedMaxAge(60);

        return $response;
    }
}
