<?php

namespace Juweliere\UserBundle\User;

use Juweliere\UserBundle\Entity\User;
use Swift_Message;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\Request;
use Twig\Environment;

class Mailer
{
    /**
     * @var Environment
     */
    private $twig;

    /**
     * @var \Swift_Mailer
     */
    private $mailer;

    /**
     * @var ParameterBagInterface
     */
    private $parameters;
    /**
     * @var string
     */
    private $subjectPrefix = "";

    /**
     * @var string
     */
    private $publicPath;
    private $mailFrom;
    private $mailFromName;

    /**
     * @param \Swift_Mailer $mailer
     * @param Environment $twig
     * @param $mailFrom
     * @param $mailFromName
     * @param $mailTo
     */
    public function __construct(
        \Swift_Mailer $mailer,
        Environment $twig,
        $mailFrom,
        $mailFromName
    )
    {
        $this->mailer = $mailer;
        $this->twig = $twig;

        $this->mailFrom = $mailFrom;
        $this->mailFromName = $mailFromName;

        $logger = new \Swift_Plugins_Loggers_ArrayLogger();
        $this->mailer->registerPlugin(new \Swift_Plugins_LoggerPlugin($logger));

        $transport = $this->mailer->getTransport();
        if($transport instanceof \Swift_Transport_EsmtpTransport){
            $transport->setStreamOptions([
                'ssl' => [
                    'allow_self_signed' => true,
                    'verify_peer' => false,
                    'verify_peer_name' => false
                ]
            ]);
        }

        if (isset($_SERVER["MAIL_SUBJECT_PREFIX"])) {
            $this->subjectPrefix = $_SERVER["MAIL_SUBJECT_PREFIX"] . " ";
        } elseif (isset($_SERVER["APP_ENV"]) && strtolower($_SERVER["APP_ENV"]) != "prod") {
            $this->subjectPrefix = "(!!! " . $_SERVER["APP_ENV"] . " !!!) ";
        }
    }

    /**
     * @param Request $request
     * @param Session $session
     * @param Customer $customer
     * @param $disclaimerFilePath
     * @return int
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function sendPasswordRecover($email, $recoverUrl)
    {
        /*
        var_dump($this->mailFrom);
        var_dump($this->mailFromName);
        var_dump($order["user"]);
        var_dump($order["user"]["email"]);
        */

        /** @var Swift_Message $message */
        $message = (new Swift_Message($this->subjectPrefix . 'Passwort zurücksetzen'))
            ->setFrom($this->mailFrom, $this->mailFromName)
            ->setTo($email)
            ->setBody($this->twig->render(
                '@JuweliereUser/mail/user/recovery.html.twig',
                array("recoverUrl" => $recoverUrl)
            ),
                'text/html');
        return $this->mailer->send($message);
    }
}
